"""
Auto-generated configuration schema components from shared_config.py
DO NOT EDIT THIS FILE MANUALLY - it will be overwritten on build
"""

from typing import TypedDict, Dict, Any, Union, cast
from enum import Enum
import sys
from pathlib import Path

# Import shared configuration constants
sys.path.insert(0, str(Path(__file__).parent.parent.parent))
from shared_config import CONFIG_SCHEMA_DEF, ConfigFieldType

# Field name constants for type-safe access
DLL = "dll"
NO_FP16 = "no_fp16"
MULTIPLIER = "multiplier"
FLOW_SCALE = "flow_scale"
PERFORMANCE_MODE = "performance_mode"
HDR_MODE = "hdr_mode"
EXPERIMENTAL_PRESENT_MODE = "experimental_present_mode"
DXVK_FRAME_RATE = "dxvk_frame_rate"
ENABLE_WOW64 = "enable_wow64"
DISABLE_STEAMDECK_MODE = "disable_steamdeck_mode"
MANGOHUD_WORKAROUND = "mangohud_workaround"
DISABLE_VKBASALT = "disable_vkbasalt"
FORCE_ENABLE_VKBASALT = "force_enable_vkbasalt"
ENABLE_WSI = "enable_wsi"
ENABLE_ZINK = "enable_zink"


class ConfigurationData(TypedDict):
    """Type-safe configuration data structure - AUTO-GENERATED"""
    dll: str
    no_fp16: bool
    multiplier: int
    flow_scale: float
    performance_mode: bool
    hdr_mode: bool
    experimental_present_mode: str
    dxvk_frame_rate: int
    enable_wow64: bool
    disable_steamdeck_mode: bool
    mangohud_workaround: bool
    disable_vkbasalt: bool
    force_enable_vkbasalt: bool
    enable_wsi: bool
    enable_zink: bool


def get_script_parsing_logic():
    """Return the script parsing logic as a callable"""
    def parse_script_values(lines):
        script_values = {}
        for line in lines:
            line = line.strip()
            if not line or line.startswith("#") or not line.startswith("export "):
                continue
            if "=" in line:
                export_line = line[len("export "):]
                key, value = export_line.split("=", 1)
                key = key.strip()
                value = value.strip()

                # Auto-generated parsing logic:
                if key == "DXVK_FRAME_RATE":
                        try:
                            script_values["dxvk_frame_rate"] = int(value)
                        except ValueError:
                            pass
                if key == "PROTON_USE_WOW64":
                        script_values["enable_wow64"] = value == "1"
                if key == "SteamDeck":
                        script_values["disable_steamdeck_mode"] = value == "0"
                if key == "MANGOHUD":
                        script_values["mangohud_workaround"] = value == "1"
                if key == "DISABLE_VKBASALT":
                        script_values["disable_vkbasalt"] = value == "1"
                if key == "ENABLE_VKBASALT":
                        script_values["force_enable_vkbasalt"] = value == "1"
                if key == "ENABLE_GAMESCOPE_WSI":
                        script_values["enable_wsi"] = value != "0"
                if key == "DXVK_HDR":
                        script_values["enable_wsi"] = value != "0"
                if key == "__GLX_VENDOR_LIBRARY_NAME" and value == "mesa":
                        script_values["enable_zink"] = True
                if key == "MESA_LOADER_DRIVER_OVERRIDE" and value == "zink":
                        script_values["enable_zink"] = True
                if key == "GALLIUM_DRIVER" and value == "zink":
                        script_values["enable_zink"] = True

        return script_values
    return parse_script_values


def get_script_generation_logic():
    """Return the script generation logic as a callable"""
    def generate_script_lines(config):
        lines = []
        dxvk_frame_rate = config.get("dxvk_frame_rate", 0)
        if dxvk_frame_rate > 0:
            lines.append(f"export DXVK_FRAME_RATE={dxvk_frame_rate}")
        if config.get("enable_wow64", False):
            lines.append("export PROTON_USE_WOW64=1")
        if config.get("disable_steamdeck_mode", False):
            lines.append("export SteamDeck=0")
        if config.get("mangohud_workaround", False):
            lines.append("export MANGOHUD=1")
        if config.get("disable_vkbasalt", False):
            lines.append("export DISABLE_VKBASALT=1")
        if config.get("force_enable_vkbasalt", False):
            lines.append("export ENABLE_VKBASALT=1")
        if not config.get("enable_wsi", False):
            lines.append("export ENABLE_GAMESCOPE_WSI=0")
            lines.append("export DXVK_HDR=0")
        if config.get("enable_zink", False):
            lines.append("export __GLX_VENDOR_LIBRARY_NAME=mesa")
            lines.append("export MESA_LOADER_DRIVER_OVERRIDE=zink")
            lines.append("export GALLIUM_DRIVER=zink")
        return lines
    return generate_script_lines


def get_function_parameters() -> str:
    """Return function signature parameters"""
    return """dll: str = "/games/Lossless Scaling/Lossless.dll",
                     no_fp16: bool = False,
                     multiplier: int = 1,
                     flow_scale: float = 0.8,
                     performance_mode: bool = False,
                     hdr_mode: bool = False,
                     experimental_present_mode: str = "fifo",
                     dxvk_frame_rate: int = 0,
                     enable_wow64: bool = False,
                     disable_steamdeck_mode: bool = False,
                     mangohud_workaround: bool = False,
                     disable_vkbasalt: bool = False,
                     force_enable_vkbasalt: bool = False,
                     enable_wsi: bool = False,
                     enable_zink: bool = False"""


def create_config_dict(**kwargs) -> ConfigurationData:
    """Create configuration dictionary from keyword arguments"""
    return cast(ConfigurationData, {
        "dll": kwargs.get("dll"),
        "no_fp16": kwargs.get("no_fp16"),
        "multiplier": kwargs.get("multiplier"),
        "flow_scale": kwargs.get("flow_scale"),
        "performance_mode": kwargs.get("performance_mode"),
        "hdr_mode": kwargs.get("hdr_mode"),
        "experimental_present_mode": kwargs.get("experimental_present_mode"),
        "dxvk_frame_rate": kwargs.get("dxvk_frame_rate"),
        "enable_wow64": kwargs.get("enable_wow64"),
        "disable_steamdeck_mode": kwargs.get("disable_steamdeck_mode"),
        "mangohud_workaround": kwargs.get("mangohud_workaround"),
        "disable_vkbasalt": kwargs.get("disable_vkbasalt"),
        "force_enable_vkbasalt": kwargs.get("force_enable_vkbasalt"),
        "enable_wsi": kwargs.get("enable_wsi"),
        "enable_zink": kwargs.get("enable_zink"),
    })


# Field lists for dynamic operations
TOML_FIELDS = ['dll', 'no_fp16', 'multiplier', 'flow_scale', 'performance_mode', 'hdr_mode', 'experimental_present_mode']
SCRIPT_FIELDS = ['dxvk_frame_rate', 'enable_wow64', 'disable_steamdeck_mode', 'mangohud_workaround', 'disable_vkbasalt', 'force_enable_vkbasalt', 'enable_wsi', 'enable_zink']
ALL_FIELDS = ['dll', 'no_fp16', 'multiplier', 'flow_scale', 'performance_mode', 'hdr_mode', 'experimental_present_mode', 'dxvk_frame_rate', 'enable_wow64', 'disable_steamdeck_mode', 'mangohud_workaround', 'disable_vkbasalt', 'force_enable_vkbasalt', 'enable_wsi', 'enable_zink']
